'use strict';

function RoundsCtrl($scope, $rootScope, $route, GroupsRoundsManager){
    $scope.groups = $route.current.locals.groups;

    $scope.calculateCurrentRounds = function(visibilityForAll) {
        angular.forEach($scope.groups, function(group){
            group.visibleInPanel = visibilityForAll && group.visibleInPanel ? group.visibleInPanel: false;
            group.showHideGroupText = 'Pokaż szczegóły'
            group.currentRoundNumber = 1;
            angular.forEach(group.RoundsManager._rounds, function(round)
            {
                if(round.is_done)
                    group.currentRoundNumber++;
            })
        });
    };
    $scope.calculateCurrentRounds(false);

    $scope.groupsOriginal = angular.copy($scope.groups);
    $scope.enableMarketModification = false;

    $scope.isChanged = function(){
        return angular.equals($scope.groups, $scope.groupsOriginal);
    }


    $scope.cancelChanges = function(){
        GroupsRoundsManager.setAllGroupsRoundsAsCorrect();
        angular.forEach($scope.groupsOriginal, function(group){
            var Group = $scope.getGroupById($scope.groups, group.id);
            angular.forEach(group.RoundsManager._rounds, function(round, i){
                Group.RoundsManager._rounds[i].start_at = round.start_at;
                Group.RoundsManager._rounds[i].market = round.market;
            })
        })
        $scope.calculateCurrentRounds(true);
    }

    $scope.getGroupById = function(groups, id){
        var Group = null;
        angular.forEach(groups, function(group){
            if(group.id === id){
                Group = group;
            }
        });
        return Group;
    }

    $scope.toggleGroupVisibility = function(group){
        group.visibleInPanel = !group.visibleInPanel;
        if(group.visibleInPanel)
            group.showHideGroupText = 'Ukryj szczegóły';
        else
            group.showHideGroupText = 'Pokaż szczegóły';
    }

    $scope.saveChanges = function(){
        GroupsRoundsManager.setAllGroupsRoundsAsCorrect();
        if(GroupsRoundsManager.validateGroupsRounds())
        {
            var i = 0;

            var message = {
                title: 'Zapisywanie rund'
                ,msg: 'Trwa zapisywanie danych o rundach. Proszę czekać...'
            }

            $scope.groups.forEach(function(group, iterator){
                var GroupToSave = angular.copy(group);
                GroupToSave.changed = false;
                delete GroupToSave.visibleInPanel;
                delete GroupToSave.showHideGroupText;
                delete GroupToSave.currentRoundNumber;
                var OriginalGroup = $scope.getGroupById($scope.groupsOriginal, GroupToSave.id);
                angular.forEach(GroupToSave.RoundsManager._rounds, function(round, i){
                    var changedStartAt = OriginalGroup.RoundsManager._rounds[i].start_at !== round.start_at,
                        changedMarket = OriginalGroup.RoundsManager._rounds[i].market !== round.market;
                    if(changedStartAt || changedMarket){
                        GroupToSave.changed = true;
                        ++i;
                    }
                })

                if(GroupToSave.changed)
                {
                    GroupToSave.rounds = angular.copy(GroupToSave.RoundsManager._rounds);
                    delete GroupToSave.RoundsManager;

                    angular.forEach(GroupToSave.rounds, function(round){
                        round.market = $scope.enableMarketModification? round.market: 0;
                    })

                    $rootScope.$broadcast('Message:addMsg', message);
                    GroupToSave.save(function(){
                        $rootScope.$broadcast('Message:delMsg', message);
                        --i;
                        if(i == 0)
                        {
                            $scope.groupsOriginal = angular.copy($scope.groups);
                        }
                    });
                }
            });
            $scope.calculateCurrentRounds(true);
        }
        else
        {
            console.log('Nieprawidłowo ustawione daty');
        }
    }


    $scope.endRound = function(group){
        $rootScope.$broadcast('ModalEndRound:show', group);
    }

    $scope.isEndedRound = function(Group, Round){
        return Group.RoundsManager.isEndedRound(Round);
    }

    $scope.isRoundNotCalculate = function(Group, Round){
        if(!Round.isStarted() || Round.is_done || Round.sequence == 8)
        {
            return false;
        }

        var NextRound = Group.RoundsManager._getNextRound(Round);
        if(NextRound !== false && !NextRound.isStarted())
        {
            return false;
        }
        return true;
    }
}

RoundsCtrl.$inject = ['$scope', '$rootScope', '$route', 'GroupsRoundsManager'];